<?php
/**
 * @package     n3t MultiModule
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\CMS\Extension\Service\Provider\HelperFactory;
use Joomla\CMS\Extension\Service\Provider\Module;
use Joomla\CMS\Extension\Service\Provider\ModuleDispatcherFactory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

/**
 * The n3t MultiModule module service provider.
 *
 * @since  4.0.0
 */
return new class implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function register(Container $container)
    {
	      $container->registerServiceProvider(new ModuleDispatcherFactory('\\Joomla\\Module\\n3tMultiModule'));
        $container->registerServiceProvider(new HelperFactory('\\Joomla\\Module\\n3tMultiModule\\Site\\Helper'));

        $container->registerServiceProvider(new Module());
    }
};
