<?php
/**
 * @package     n3t MultiModule module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Module\n3tMultiModule\Site\Dispatcher;

\defined('_JEXEC') or die;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\Module\n3tMultiModule\Site\Helper\N3TMultiModuleHelper;

/**
 * Dispatcher class for n3t MultiModule module
 *
 * @since  4.0.0
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
    use HelperFactoryAwareTrait;

    /**
     * Returns the layout data.
     *
     * @return  array
     *
     * @since   4.0.0
     */
    protected function getLayoutData(): array
    {
        $data = parent::getLayoutData();

				/** @var N3TMultiModuleHelper $helper */
				$helper = $this->getHelperFactory()->getHelper('N3tMultiModuleHelper');
	      $data['helper'] = $helper;

        return $data;
    }
}
