<?php
/**
 * @package     n3t MultiModule module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Module\n3tMultiModule\Site\Helper;

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Registry\Registry;

/**
 * Helper class for n3t MultiModule module
 *
 * @since  4.0.0
 */
class N3TMultiModuleHelper
{
	public function loadModulePosition(?string $position, ?string $style): string {
		if (!$position) {
			return '';
		}

		$document = Factory::getApplication()->getDocument();
		$renderer = $document->loadRenderer('module');
		$modules  = ModuleHelper::getModules($position);

		ob_start();
		foreach ($modules as $module) {
			if ($style) {
				$module->params = new Registry($module->params);
				$module->params->set('style', $style);
			}
			echo $renderer->render($module, []);
		}

		return ob_get_clean();
	}
}
