<?php
/**
 * @package     n3t PhocaCart Category module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\Module\n3tPhocaCartCategory\Site\Helper\N3TPhocacartCategoryHelper;
use Joomla\Registry\Registry;

/** @var array $categories */
/** @var Registry $params */
/** @var N3TPhocacartCategoryHelper $helper */
/** @var string $itemsTemplate */
/** @var int $level */

if (!$categories) {
	return;
}
?>
<ul class="<?php echo $level ? 'mod-menu__sub list-unstyled small' : 'mod-menu mod-list nav' ?>">
  <?php foreach ($categories as $category) { ?>
    <?php
      if ($params->get('show_featured', 0) == 1 && $category->featured) {
        continue;
      }

      if ($params->get('show_featured', 0) == 2 && !$category->featured) {
        continue;
      }

      $class = [
        'level-' . $level
      ];

      if ($category->current) {
        $class[] = 'current';
      }

      if ($category->active) {
        $class[] = 'active';
      }

      if ($category->children) {
        $class[] = 'has-children';
      }
    ?>
    <li class="<?php echo implode(' ', $class) ?>">
      <a href="<?php echo $helper->categoryLink($category); ?>"><?php echo $category->title; ?></a>
      <?php
      if ($helper->isExpanded($category) && $category->children) {
        $currentCategories = $categories;
        $categories        = $category->children;
        $level++;
        require $itemsTemplate;
        $categories = $currentCategories;
        $level--;
      }
      ?>
    </li>
  <?php } ?>
</ul>
