<?php
/**
 * @package     n3t PhocaCart Category module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\Adapter\ModuleAdapter;
use Joomla\CMS\Installer\InstallerScript;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Version;
use Joomla\Registry\Registry;

/**
 * @since   4.0.0
 */
class mod_N3t_PhocaCart_CategoryInstallerScript extends InstallerScript
{
	const LANG_PREFIX = 'MOD_N3T_PHOCACART_CATEGORY';
	protected $minimumJoomla = '4.2.0';
	protected $minimumPhp = '7.4.0';
	protected $allowDowngrades = true;
	protected $oldRelease = null;

	/**
	 * @inheritdoc
	 *
	 * @since 4.0.1
	 */
	public function preflight($type, $parent)
	{
		$return = parent::preflight($type, $parent);

		if (strtolower($type) === 'update') {
			$manifest = $this->getItemArray('manifest_cache', '#__extensions', 'element', $this->extension);
			if (isset($manifest['version'])) {
				$this->oldRelease = $manifest['version'];
			}
		}
		return $return;
	}

	/**
	 * @inheritdoc
	 *
	 * @since 4.0.0
	 */
	public function update(ModuleAdapter $parent)
	{
		if ($this->oldRelease) {
			Factory::getApplication()->enqueueMessage(Text::sprintf(self::LANG_PREFIX . '_INSTALL_UPDATE_VERSION', $this->oldRelease, $this->release));
		}
	}

}
