<?php
/**
 * @package     n3t PhocaCart Category module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Module\n3tPhocaCartCategory\Site\Dispatcher;

\defined('_JEXEC') or die;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\Module\n3tPhocaCartCategory\Site\Helper\N3TPhocacartCategoryHelper;

/**
 * Dispatcher class for n3t PhocaCart Category module
 *
 * @since  4.0.0
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
    use HelperFactoryAwareTrait;

    /**
     * Returns the layout data.
     *
     * @return  array
     *
     * @since   4.0.0
     */
    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

				/** @var N3TPhocacartCategoryHelper $helper */
				$helper = $this->getHelperFactory()->getHelper('N3tPhocacartCategoryHelper');
	      $helper
		      ->setApplication($this->getApplication())
	        ->setParams($data['params']);
	      $data['helper'] = $helper;
        $data['categories'] = $helper->getCategories();
	      $data['app'] = $this->app;

        return $data;
    }
}
