<?php
/**
 * @package     n3t PhocaCart Category module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Module\n3tPhocaCartCategory\Site\Helper\N3TPhocacartCategoryHelper;
use Joomla\Registry\Registry;

/** @var array $categories */
/** @var Registry $params */
/** @var N3TPhocacartCategoryHelper $helper */
/** @var CMSApplicationInterface $app */
/** @var WebAssetManager $wa */

if (!$helper->isPhocaCart() || !$categories) {
	return;
}

HTMLHelper::_('bootstrap.collapse');

$wa = $app->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('mod_n3t_phocacart_category');
$wa->usePreset('mod_n3t_phocacart_category.bs5_listgroup');

$itemsTemplate = ModuleHelper::getLayoutPath('mod_n3t_phocacart_category', $params->get('layout', 'collapse') . '_items');
$level = 1;
$parentCategory = null;
require $itemsTemplate;
