<?php
/**
 * @package     n3t PhocaCart Category module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\Module\n3tPhocaCartCategory\Site\Helper\N3TPhocacartCategoryHelper;
use Joomla\Registry\Registry;

/** @var object $parentCategory */
/** @var array $categories */
/** @var Registry $params */
/** @var object $module */
/** @var N3TPhocacartCategoryHelper $helper */
/** @var string $itemsTemplate */
/** @var int $level */

if (!$categories) {
	return;
}

$id = '';
if ($parentCategory) {
  $class = [
    'collapse',
  ];
  if ($helper->isExpanded($parentCategory)) {
    $class[] = 'show';
  }
  $id = ' id="mod_n3t_phocacart_category__dropdown-' . $module->id . '-' . $parentCategory->id . '"';
} else {
  $class = [
    'mod_n3t_phocacart_category__list',
    'mod_n3t_phocacart_category__indent',
    'list-group',
  ];
}
?>
<div class="<?php echo implode(' ', $class) ?>"<?php echo $id; ?>>
  <?php foreach ($categories as $category) { ?>
    <?php
    if ($params->get('show_featured', 0) == 1 && $category->featured) {
      continue;
    }

    if ($params->get('show_featured', 0) == 2 && !$category->featured) {
      continue;
    }

    if ($params->get('end_level') && $category->level > (int)$params->get('end_level')) {
      continue;
    }

    $class = [
      'list-group-item',
      'level-' . $level,
      'item-' . $category->id,
    ];

    if ($category->current) {
      $class[] = 'current';
    }

    if ($category->active) {
      $class[] = 'active';
    }

    if ($category->children) {
      $class[] = 'parent';
    }
  ?>
      <a href="<?php echo $helper->categoryLink($category); ?>" class="<?php echo implode(' ', $class) ?>"
        <?php echo $category->children ? 'data-bs-toggle="collapse" data-bs-target="#mod_n3t_phocacart_category__dropdown-' . $module->id . '-' . $category->id . '"' : ''; ?>
      >
        <span><?php echo $category->title; ?></span>
        <?php if ($params->get('description_length') && $category->description) { ?>
          <small class="d-block"><?php echo $helper->truncate($category->description, (int)$params->get('description_length')); ?></small>
        <?php } ?>
      </a>
      <?php
      if ($category->children) {
        $currentCategories = $categories;
        $parentCategory    = $category;
        $categories        = $category->children;
        $level++;
        require $itemsTemplate;
        $categories = $currentCategories;
        $level--;
      }
      ?>
  <?php } ?>
</div>
