<?php
/**
 * @package     n3t PhocaCart Category module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\Module\n3tPhocaCartCategory\Site\Helper\N3TPhocacartCategoryHelper;
use Joomla\Registry\Registry;

/** @var array $categories */
/** @var Registry $params */
/** @var N3TPhocacartCategoryHelper $helper */
/** @var string $itemsTemplate */
/** @var int $level */

if (!$categories) {
	return;
}
?>
<ul class="<?php echo $level == 1 ? 'mod_n3t_phocacart_category__list nav flex-column' : 'list-unstyled small ps-3' ?>">
  <?php foreach ($categories as $category) { ?>
    <?php
    if ($params->get('show_featured', 0) == 1 && $category->featured) {
      continue;
    }

    if ($params->get('show_featured', 0) == 2 && !$category->featured) {
      continue;
    }

    if ($params->get('end_level') && $category->level > (int)$params->get('end_level')) {
      continue;
    }

    $class = [
      'nav-item',
      'py-1',
      'level-' . $level,
      'item-' . $category->id,
    ];

    if ($category->current) {
      $class[] = 'current';
    }

    if ($category->active) {
      $class[] = 'active';
    }

    if ($helper->isExpanded($category) && $category->children) {
      $class[] = 'parent';
    }

    if ($category->children) {
      $class[] = 'has-children';
    }
  ?>
    <li class="<?php echo implode(' ', $class) ?>">
      <a href="<?php echo $helper->categoryLink($category); ?>" class="text-decoration-none d-inline-block">
        <?php echo $category->title; ?>
        <?php if ($params->get('description_length') && $category->description) { ?>
          <small class="d-block"><?php echo $helper->truncate($category->description, (int)$params->get('description_length')); ?></small>
        <?php } ?>
      </a>
      <?php
      if ($helper->isExpanded($category) && $category->children) {
        $currentCategories = $categories;
        $categories        = $category->children;
        $level++;
        require $itemsTemplate;
        $categories = $currentCategories;
        $level--;
      }
      ?>
    </li>
  <?php } ?>
</ul>
