<?php
/**
 * @package     n3t PhocaCart Category module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\Module\n3tPhocaCartCategory\Site\Helper\N3TPhocacartCategoryHelper;
use Joomla\Registry\Registry;

/** @var array $categories */
/** @var Registry $params */
/** @var N3TPhocacartCategoryHelper $helper */
/** @var string $itemsTemplate */
/** @var int $level */

if (!$categories) {
	return;
}
?>
<ul class="<?php echo $level == 1 ? 'mod_n3t_phocacart_category__list uk-nav uk-nav-default' : 'uk-nav-sub' ?>">
  <?php foreach ($categories as $category) { ?>
    <?php
    if ($params->get('show_featured', 0) == 1 && $category->featured) {
      continue;
    }

    if ($params->get('show_featured', 0) == 2 && !$category->featured) {
      continue;
    }

    if ($params->get('end_level') && $category->level > (int)$params->get('end_level')) {
      continue;
    }

    $class = [
      'level-' . $level,
      'item-' . $category->id,
    ];

    if ($category->current) {
      $class[] = 'current';
    }

    if ($category->active) {
      $class[] = 'uk-active';
    }

    if ($helper->isExpanded($category) && $category->children) {
      $class[] = 'uk-parent';
    }

    if ($category->children) {
      $class[] = 'has-children';
    }
    ?>
    <li class="<?php echo implode(' ', $class) ?>">
      <a href="<?php echo $helper->categoryLink($category); ?>">
        <div>
          <?php echo $category->title; ?>
          <?php if ($params->get('description_length') && $category->description) { ?>
            <div class="uk-nav-subtitle"><?php echo $helper->truncate($category->description, (int)$params->get('description_length')); ?></div>
          <?php } ?>
        </div>
      </a>
      <?php
      if ($helper->isExpanded($category) && $category->children) {
        $currentCategories = $categories;
        $categories        = $category->children;
        $level++;
        require $itemsTemplate;
        $categories = $currentCategories;
        $level--;
      }
      ?>
    </li>
  <?php } ?>
</ul>
