<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerScript;
use Joomla\CMS\Language\Text;

/**
 * @since   4.0.0
 */
class mod_N3t_PhocaCart_SearchInstallerScript extends InstallerScript
{
	const LANG_PREFIX = 'MOD_N3T_PHOCACART_SEARCH';
	protected $minimumJoomla = '4.2.0';
	protected $minimumPhp = '7.4.0';
	protected $allowDowngrades = true;
	protected $oldRelease = null;

	/**
	 * @inheritdoc
	 *
	 * @since 4.0.2
	 */
	public function preflight($type, $parent)
	{
		$return = parent::preflight($type, $parent);
		$manifest = $this->getItemArray('manifest_cache', '#__extensions', 'element', $this->extension);
		if (isset($manifest['version'])) {
			$this->oldRelease = $manifest['version'];
		}

		return $return;
	}

	/**
	 * @inheritdoc
	 *
   * @since 4.0.0
   */
  public function update($parent)
  {
	  if ($this->oldRelease) {
		  Factory::getApplication()->enqueueMessage(Text::sprintf(self::LANG_PREFIX . '_INSTALL_UPDATE_VERSION', $this->oldRelease, $this->release));
	  }
  }

}
