<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Module\n3tPhocaCartSearch\Site\Dispatcher;

\defined('_JEXEC') or die;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\CMS\Version;
use Joomla\Event\DispatcherInterface;
use Joomla\Module\n3tPhocaCartSearch\Site\Helper\N3TPhocacartSearchHelper;

/**
 * Dispatcher class for n3t PhocaCart Search module
 *
 * @since  4.0.0
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
	use HelperFactoryAwareTrait;

	/**
	 * Returns the layout data.
	 *
	 * @return  array
	 *
	 * @since   4.0.0
	 */
	protected function getLayoutData()
	{
		$data = parent::getLayoutData();

		/** @var N3TPhocacartSearchHelper $helper */
		$helper = $this->getHelperFactory()->getHelper('N3tPhocacartSearchHelper');
		$helper
			->setApplication($this->getApplication())
			->setParams($data['params'])
			->loadPhocaCart();

		if (Version::MAJOR_VERSION >= 5) {
			/** @var DispatcherInterface $dispatcher */
			$dispatcher = Factory::getContainer()->get(DispatcherInterface::class);
			$dispatcher->addSubscriber($helper);
		}

		$data['helper'] = $helper;
		$data['currentSearch'] = $this->app->getInput()->get('search', null, 'string');
		$data['app'] = $this->app;

		return $data;
	}
}
