<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\Module\n3tPhocaCartSearch\Site\Helper\n3TPhocaCartSearchHelper;
use Joomla\Registry\Registry;

/** @var stdClass $module */
/** @var n3TPhocaCartSearchHelper $helper */
/** @var ?string $currentSearch */
/** @var CMSApplicationInterface $app */
/** @var Registry $params */
/** @var WebAssetManager $wa */

if (!$helper->isPhocaCart()) {
  return;
}

$wa = $app->getDocument()->getWebAssetManager();
$wa->getRegistry()->addExtensionRegistryFile('mod_n3t_phocacart_search');
$wa->usePreset('mod_n3t_phocacart_search.ajax_search');

Text::script('MOD_N3T_PHOCACART_SEARCH_JS_RESPONSE_ERROR');
?>
<form
  action="<?= Route::_($helper->getItemsRoute()); ?>"
  method="GET"
  data-n3t-ajax-search="<?= Route::_('index.php?option=com_ajax&module=' . $module->name . '&id=' . $module->id . '&format=raw', true,Route::TLS_IGNORE, true); ?>"
  data-n3t-ajax-search-timeout="<?= $params->get('timeout', 500); ?>"
  data-n3t-ajax-search-length="<?= $params->get('min_length', 3); ?>"
  autocomplete="off"
>
  <div class="input-group">
    <label class="visually-hidden" for="n3t-phocacart-search-<?= $module->id; ?>"><?= Text::_('MOD_N3T_PHOCACART_SEARCH_SEARCH'); ?></label>
    <input type="search" name="search" class="form-control" value="<?= $currentSearch; ?>" id="n3t-phocacart-search-<?= $module->id; ?>" aria-label="<?= Text::_('MOD_N3T_PHOCACART_SEARCH_SEARCH'); ?>" placeholder="<?= Text::_('MOD_N3T_PHOCACART_SEARCH_SEARCH'); ?>" />
    <?php if ($params->get('show_button', 1)) { ?>
      <?php $s = PhocacartRenderStyle::getStyles(); ?>
      <button type="submit" class="btn btn-outline-primary" aria-label="<?= Text::_('MOD_N3T_PHOCACART_SEARCH_SEARCH'); ?>"><?= \PhocacartRenderIcon::icon($s['i']['search']); ?></button>
    <?php } ?>
  </div>
</form>
