<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;

/** @var array $categories */
/** @var Registry $phocaCartParams */

if (!$categories) {
  return;
}
?>
<div class="n3t_phocacart_search__categories">
  <h6><?= Text::_('MOD_N3T_PHOCACART_SEARCH_CATEGORIES_HEADING'); ?></h6>
  <ul>
    <?php foreach ($categories as $category) { ?>
      <li>
        <a href="<?= Route::_(\PhocacartRoute::getCategoryRoute($category->id, $category->alias))?>">
          <?= $category->title; ?>
        </a>
      </li>
    <?php } ?>
  </ul>
</div>
