<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Module\n3tPhocaCartSearch\Site\Helper\n3TPhocaCartSearchHelper;
use Joomla\Registry\Registry;

/** @var array $manufacturers */
/** @var n3TPhocaCartSearchHelper $helper */

if (!$manufacturers) {
  return;
}
?>
<div class="n3t_phocacart_search__manufacturers">
  <h6><?= Text::_('MOD_N3T_PHOCACART_SEARCH_MANUFACTURERS_HEADING'); ?></h6>
  <ul>
    <?php foreach ($manufacturers as $manufacturer) { ?>
      <li>
        <a href="<?= Route::_($helper->getManufacturerRoute($manufacturer->id, $manufacturer->alias))?>">
          <?= $manufacturer->title; ?>
        </a>
      </li>
    <?php } ?>
  </ul>
</div>
