<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Module\n3tPhocaCartSearch\Site\Helper\n3TPhocaCartSearchHelper;
use Joomla\Registry\Registry;

/** @var stdClass $module */
/** @var n3TPhocaCartSearchHelper $helper */
/** @var array $products */
/** @var int $productsCount */
/** @var string $currentSearch */
/** @var Registry $params */
/** @var Registry $phocaCartParams */

if (!$products) {
  return;
}
?>
<ul class="n3t_phocacart_search__products">
  <?php foreach ($products as $product) { ?>
    <li>
      <a href="<?= Route::_(\PhocacartRoute::getProductCanonicalLink($product->id, $product->cat_id, $product->alias, $product->cat_alias, $product->pref_cat_id))?>">
        <?php if ($params->get('show_images', 1)) { ?>
          <?php require ModuleHelper::getLayoutPath($module->module, $params->get('layout', 'default') . '_products_image');?>
        <?php } ?>

        <?php if ($params->get('show_manufacturers', 1)) { ?>
          <span class="manufacturer">
            <?= $product->manufacturer_title; ?>
          </span>
        <?php } ?>

        <span class="title">
          <?= $product->title; ?>
          <?php if ($params->get('show_categories', 1)) { ?>
            <small class="category"><?= $product->pref_cat_title ?: $product->cat_title; ?></small>
          <?php } ?>
        </span>

        <?php if ($params->get('show_prices', 1)) { ?>
          <?php require ModuleHelper::getLayoutPath($module->module, $params->get('layout', 'default') . '_products_price');?>
        <?php } ?>
      </a>
    </li>
  <?php } ?>
</ul>

<div class="n3t_phocacart_search__total">
  <a href="<?= Route::_($helper->getItemsRoute($currentSearch)); ?>">
    <?= Text::sprintf('MOD_N3T_PHOCACART_RESULTS_COUNT', $productsCount); ?>
  </a>
</div>

