<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;
use Joomla\Registry\Registry;

/** @var stdClass $product */
/** @var Registry $phocaCartParams */

$pathItem = \PhocacartPath::getPath('productimage');
$image = \PhocacartImage::getThumbnailName($pathItem, $product->image,'small');
?>
<span class="image">
<?php if ($image->rel ?? null) { ?>
  <picture>
    <?php if ($phocaCartParams->get('display_webp_images') && ($image->rel_webp ?? null)) { ?>
      <source srcset="<?= Uri::base(true) . '/' . $image->rel_webp; ?>" type="image/webp" />
    <?php } ?>
    <img src="<?= Uri::base(true) . '/' . $image->rel; ?>" alt="<?= htmlspecialchars($product->title); ?>" />
  </picture>
<?php } ?>
</span>
