<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\Module\n3tPhocaCartSearch\Site\Helper\n3TPhocaCartSearchHelper;
use Joomla\Registry\Registry;

/** @var stdClass $product */
/** @var Registry $phocaCartParams */
/** @var n3TPhocaCartSearchHelper $helper */

$priceHelper = new \PhocacartPrice;

$price = $helper->getProductPrice($product);
$priceOriginal = $helper->getProductPriceOriginal($product);
$isZeroPrice = isset($price['brutto']) && $price['brutto'] == 0;

$onDemandText = $phocaCartParams->get( 'price_on_demand_text');
$zeroPriceText = $phocaCartParams->get( 'zero_price_text');
?>
<span class="prices">
  <?php if ($priceOriginal) { ?>
    <span class="price-original">
      <?= $priceOriginal['bruttoformat'] ?>
    </span>
  <?php } ?>

  <span class="price">
    <?php if ($isZeroPrice && $product->type === 3 && $onDemandText) { ?>
      <?= $onDemandText == '0' ? '' : $onDemandText; ?>
    <?php } else if ($isZeroPrice && $zeroPriceText) { ?>
      <?= $zeroPriceText == '0' ? '' : $zeroPriceText; ?>
    <?php } else { ?>
      <?= $price['bruttoformat'] ?>
    <?php } ?>
  </span>
</span>
