<?php
/**
 * @package     n3t PhocaCart Search module
 *
 * @author      Pavel Poles - n3t.cz
 * @copyright   (C) 2023-2024 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 **/

// no direct access
\defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Module\n3tPhocaCartSearch\Site\Helper\n3TPhocaCartSearchHelper;

/** @var array $tags */
/** @var n3TPhocaCartSearchHelper $helper */

if (!$tags) {
  return;
}
?>
<div class="n3t_phocacart_search__tags">
  <h6><?= Text::_('MOD_N3T_PHOCACART_SEARCH_TAGS_HEADING'); ?></h6>
  <ul>
    <?php foreach ($tags as $tag) { ?>
      <li>
        <a href="<?= Route::_($helper->getTagRoute($tag->id, $tag->alias))?>">
          <?= $tag->title; ?>
        </a>
      </li>
    <?php } ?>
  </ul>
</div>
