<?php
/**
 * @package n3t Article
 * @author Pavel Poles - n3t.cz
 * @copyright (c) 2012 - 2018 - Pavel Poles - n3t.cz
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

// no direct access
defined('_JEXEC') or die;

use Joomla\Registry\Registry;

require_once JPATH_SITE.'/components/com_content/helpers/route.php';
jimport('joomla.application.component.model');
JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_content/models', 'ContentModel');

abstract class modN3tArticleHelper
{

	public static function getArticle(&$params)
	{
    $articleid = $params->get('articleid');
    
		$app	= JFactory::getApplication();
    $user		= JFactory::getUser();		
    $dispatcher	= JDispatcher::getInstance();

		$model = JModelLegacy::getInstance('Article', 'ContentModel', array('ignore_request' => true));

		$appParams = JFactory::getApplication()->getParams();
    $model->setState('article.id', $articleid);
		$model->setState('params', $appParams);
		
		if ((!$user->authorise('core.edit.state', 'com_content')) &&  (!$user->authorise('core.edit', 'com_content'))) {
			$model->setState('filter.published', 1);
			$model->setState('filter.archived', 2);
		}

		$item = $model->getItem();
    
		$item->slug			= $item->alias ? ($item->id.':'.$item->alias) : $item->id;
		$item->catslug		= $item->category_alias ? ($item->catid.':'.$item->category_alias) : $item->catid;
		$item->parent_slug	= $item->category_alias ? ($item->parent_id.':'.$item->parent_alias) : $item->parent_id;
		if ($item->parent_alias == 'root')
		{
			$item->parent_slug = null;
		}
    
    $item->params->merge($params);

    $item->readmore = $item->fulltext ? true : false;     		
    $item->readmore_link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language));

  	$item->text = $item->introtext;

		$item->tags = new JHelperTags;
		$item->tags->getItemTags('com_content.article', $item->id);
    
		$articleParams = new Registry;
		$articleParams->loadString($item->attribs);

		$item->alternative_readmore = $articleParams->get('alternative_readmore');    

		JPluginHelper::importPlugin('content');
		$dispatcher->trigger('onContentPrepare', array ('com_content.article', &$item, &$item->params, 0));

		$item->event = new stdClass;
		$results = $dispatcher->trigger('onContentAfterTitle', array('com_content.article', &$item, &$item->params, 0));
		$item->event->afterDisplayTitle = trim(implode("\n", $results));

		$results = $dispatcher->trigger('onContentBeforeDisplay', array('com_content.article', &$item, &$item->params, 0));
		$item->event->beforeDisplayContent = trim(implode("\n", $results));

		$results = $dispatcher->trigger('onContentAfterDisplay', array('com_content.article', &$item, &$item->params, 0));
		$item->event->afterDisplayContent = trim(implode("\n", $results));

		return $item;
	}
}
