<?php
/**
 * @package n3t Article
 * @author Pavel Poles - n3t.cz
 * @copyright (c) 2012 - 2018 - Pavel Poles - n3t.cz
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

defined('_JEXEC') or die;

$params = $item->params;
JHtml::addIncludePath(JPATH_BASE . '/components/com_content/helpers');
$canEdit = $params->get('access-edit');
$info = $params->get('info_block_position', 0);
$assocParam = (JLanguageAssociations::isEnabled() && $params->get('show_associations'));
?>
<div class="n3tArticle<?php echo $moduleclass_sfx; ?>">
<?php if ($item->state == 0 || strtotime($item->publish_up) > strtotime(JFactory::getDate())
  || ((strtotime($item->publish_down) < strtotime(JFactory::getDate())) && $item->publish_down != JFactory::getDbo()->getNullDate())) : ?>
<div class="system-unpublished">
<?php endif; ?>

<?php if ($item->state == 0 || $params->get('show_title') || ($params->get('show_author') && !empty($item->author ))) : ?> 
  <?php if ($params->get('show_title')) : ?> 
    <h4 itemprop="name">
      <?php if ($params->get('link_titles') && ($params->get('access-view') || $params->get('show_noauth', '0') == '1')) : ?>
        <a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)); ?>" itemprop="url">
        <?php echo $item->title; ?></a>
      <?php else : ?>
        <?php echo $item->title; ?>
      <?php endif; ?>
    </h4>
  <?php endif; ?>

  <?php if ($item->state == 0) : ?>
    <span class="label label-warning"><?php echo JText::_('JUNPUBLISHED'); ?></span>
  <?php endif; ?>

  <?php if (strtotime($item->publish_up) > strtotime(JFactory::getDate())) : ?>
    <span class="label label-warning"><?php echo JText::_('JNOTPUBLISHEDYET'); ?></span>
  <?php endif; ?>
  
  <?php if ($item->publish_down != JFactory::getDbo()->getNullDate()
    && (strtotime($item->publish_down) < strtotime(JFactory::getDate()))
  ) : ?>
    <span class="label label-warning"><?php echo JText::_('JEXPIRED'); ?></span>
  <?php endif; ?>
<?php endif; ?>

<?php if ($canEdit || $params->get('show_print_icon') || $params->get('show_email_icon')) : ?>
  <?php echo JLayoutHelper::render('joomla.content.icons', array('params' => $params, 'item' => $item, 'print' => false)); ?>
<?php endif; ?>

<?php if ($params->get('show_tags') && !empty($item->tags->itemTags)) : ?>
  <?php echo JLayoutHelper::render('joomla.content.tags', $item->tags->itemTags); ?>
<?php endif; ?>
<?php $useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
  || $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category') || $params->get('show_author') ); ?>

<?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
  <?php echo JLayoutHelper::render('joomla.content.info_block.block', array('item' => $item, 'params' => $params, 'position' => 'above')); ?>
  <?php if ($info == 0 && $params->get('show_tags', 1) && !empty($item->tags->itemTags)) : ?>
    <?php echo JLayoutHelper::render('joomla.content.tags', $item->tags->itemTags); ?>
  <?php endif; ?>
<?php endif; ?>

<?php echo JLayoutHelper::render('joomla.content.intro_image', $item); ?>


<?php if (!$item->params->get('show_intro')) : ?>
  <?php echo $item->event->afterDisplayTitle; ?>
<?php endif; ?>
<?php echo $item->event->beforeDisplayContent; ?>

<?php echo $item->text; ?>

<?php if ($useDefList && ($info == 1 || $info == 2)) : ?>
  <?php echo JLayoutHelper::render('joomla.content.info_block.block', array('item' => $item, 'params' => $params, 'position' => 'below')); ?>
  <?php if ($params->get('show_tags', 1) && !empty($item->tags->itemTags)) : ?>
    <?php echo JLayoutHelper::render('joomla.content.tags', $item->tags->itemTags); ?>
  <?php endif; ?>
<?php endif; ?>

<?php if ($item->readmore) :
  if ($item->params->get('access-view')) :
    $link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language));
  else :
    $menu = JFactory::getApplication()->getMenu();
    $active = $menu->getActive();
    $itemId = $active->id;
    $link = new JUri(JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
    $link->setVar('return', base64_encode(ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)));
  endif; ?>
  
  <?php echo JLayoutHelper::render('joomla.content.readmore', array('item' => $item, 'params' => $params, 'link' => $link)); ?>
  
<?php endif; ?>

<?php if ($item->state == 0 || strtotime($item->publish_up) > strtotime(JFactory::getDate())
  || ((strtotime($item->publish_down) < strtotime(JFactory::getDate())) && $item->publish_down != JFactory::getDbo()->getNullDate())) : ?>
</div>
<?php endif; ?>

<?php echo $item->event->afterDisplayContent; ?>

</div>