<?php
/**
 * @package n3t Debug
 * @author Pavel Poles - n3t.cz
 * @copyright (C) 2016-2021 - Pavel Poles - n3t.cz
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

defined( '_JEXEC' ) or die( 'Restricted access' );

use n3tDebug\Joomla\Profiler;
use Tracy\ILogger;

class n3tDebug {

  public static function enabled()
  {
    return class_exists('\\Tracy\\Debugger');
  }

  public static function dump($var, bool $return = false)
  {
    if (!self::enabled()) return null;

    return \Tracy\Debugger::dump($var, $return);
  }

  public static function timer(string $name = NULL): float
  {
    if (!self::enabled()) return 0;

    return \Tracy\Debugger::timer($name);
  }

  public static function barDump($var, string $title = NULL, array $options = [])
  {
    if (!self::enabled()) return null;

    return \Tracy\Debugger::barDump($var, $title, $options);
  }

  public static function log($message, string $priority = ILogger::INFO)
  {
    if (!self::enabled()) return null;

    return \Tracy\Debugger::log($message, $priority);
  }

  public static function fireLog($message)
  {
    if (!self::enabled()) return null;

    return \Tracy\Debugger::fireLog($message);
  }

  public static function profile(string $prefix, string $label = ''): void
  {
    if (!self::enabled()) return;

    if (!Profiler::exists($prefix))
      Profiler::getInstance($prefix)->setStart(microtime(true), memory_get_usage());

    if ($label)
      Profiler::getInstance($prefix)->mark($label);
  }

}