<?php
/**
 * @package n3t Debug
 * @author Pavel Poles - n3t.cz
 * @copyright (C) 2016-2021 - Pavel Poles - n3t.cz
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

namespace n3tDebug\Panel;

defined( '_JEXEC' ) or die( 'Restricted access' );

use n3tDebug\Helper;
use n3tDebug\Panel;
use Joomla\CMS\Version;

class JSession extends Panel {

  public function collectData(): void
  {
    if ($this->hasData())
      return;
    if (!$this->isSessionActive())
      return;

    if (Version::MAJOR_VERSION == 3)
      $this->data = $this->getSession()->getData()->toArray();
    else
      $this->data = $this->getSession()->all();
  }

  protected function getIcon(): string
  {
    return '<svg viewBox="0 0 16 16" width="32" height="32" style="vertical-align: text-bottom">' .
      '<path fill="' . Helper::COLOR_GRAY . '" d="M14.341 3.579c-0.347-0.473-0.831-1.027-1.362-1.558s-1.085-1.015-1.558-1.362c-0.806-0.591-1.197-0.659-1.421-0.659h-7.75c-0.689 0-1.25 0.561-1.25 1.25v13.5c0 0.689 0.561 1.25 1.25 1.25h11.5c0.689 0 1.25-0.561 1.25-1.25v-9.75c0-0.224-0.068-0.615-0.659-1.421v0 0zM12.271 2.729c0.48 0.48 0.856 0.912 1.134 1.271h-2.406v-2.405c0.359 0.278 0.792 0.654 1.271 1.134v0 0zM14 14.75c0 0.136-0.114 0.25-0.25 0.25h-11.5c-0.135 0-0.25-0.114-0.25-0.25v-13.5c0-0.135 0.115-0.25 0.25-0.25 0 0 7.749-0 7.75 0v3.5c0 0.276 0.224 0.5 0.5 0.5h3.5v9.75z"></path>' .
      '<path fill="' . Helper::COLOR_SUCCESS . '" d="M10.5 9h-0.5v-2.5c0-0.276-0.224-0.5-0.5-0.5h-3c-0.276 0-0.5 0.224-0.5 0.5v2.5h-0.5c-0.275 0-0.5 0.225-0.5 0.5v4c0 0.275 0.225 0.5 0.5 0.5h5c0.275 0 0.5-0.225 0.5-0.5v-4c0-0.275-0.225-0.5-0.5-0.5zM7 7h2v2h-2v-2z"></path>' .
      '</svg> ';
  }

  protected function getTitle(): string
  {
    return 'Joomla Session';
  }

  protected function getPanelBody(): string
  {
    $html = '<table class="tracy-sortable">';
    $html.= '<tbody>';
    $html.= '<tr><th>Name</th><th>' . session_name() . '</th><tr>';
    $html.= '<tr><th>ID</th><th>' . session_id() . '</th><tr>';
    $html.= '<tr><th>Active</th><th>'.(session_status() == PHP_SESSION_ACTIVE ? 'Active' : 'Inactive' ) .'</th><tr>';
    foreach($this->data as $name => $value) {
      $html.= '<tr>';
      $html.= '<td>'.$name.'</td>';
      $html.= '<td>'.\Tracy\Dumper::toHtml($value, array(\Tracy\Dumper::COLLAPSE => true)).'</td>';
      $html.= '</tr>';
    }
    $html.= '</tbody>';
    $html.= '</table>';

    return $html;
  }


  public function onAfterRespond()
  {

  }
}