<?php
/**
 * @package n3t Debug
 * @author Pavel Poles - n3t.cz
 * @copyright (C) 2016-2021 - Pavel Poles - n3t.cz
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Utilities\IpHelper;
use Tracy\Debugger;
use Joomla\CMS\Version;

class plgSystemN3tDebug extends CMSPlugin {

  private $panels = [];
  private $enabled = false;

  public function __construct(&$subject, $config = array())
  {
    parent::__construct($subject, $config);

    $app = Factory::getApplication();

    if ($app->isClient('site') && !$this->params->get('enabled_site', '0'))
      return;

    if ($app->isClient('administrator') && !$this->params->get('enabled_admin', '0'))
      return;

    $ipList = preg_split('/\s*\n\s*/', $this->params->get('ip_list', ''));
    if (!IpHelper::IPinList(IpHelper::getIp(), $ipList))
      return;

    $this->enabled = true;
  }

  private function panelEnabled(string $name): bool
  {
    return $this->params->get('panel_' . strtolower($name) , '1') == 1;
  }

  private function addPanel($name)
  {
    if ($this->panelEnabled($name)) {
      $class = '\\n3tDebug\\Panel\\'.$name;
      $panel = new $class($this->params);
      $this->panels[$name] = $panel;
      Debugger::getBar()->addPanel($panel);
    }
  }

  public function onAfterInitialise()
  {
    if (Version::MAJOR_VERSION == 3)
      JLoader::registerNamespace('n3tDebug', __DIR__ . DIRECTORY_SEPARATOR);
    else
      JLoader::registerNamespace('n3tDebug', __DIR__ . DIRECTORY_SEPARATOR . 'n3tDebug');
    JLoader::register('n3tDebug', __DIR__ . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'n3tDebug.php');

    if (!$this->enabled)
      return;

    jimport('tracy.tracy');
    Debugger::enable(Debugger::DEVELOPMENT);
    Debugger::$dumpTheme = $this->params->get('dump_theme', 'light');
    Debugger::$scream = !!$this->params->get('scream', false);
    if ($this->params->get('strict_mode', false)) {
      Debugger::$strictMode = E_ALL;
      foreach ($this->params->get('strict_mode_ignore_levels', [E_DEPRECATED, E_USER_DEPRECATED]) as $mode)
        Debugger::$strictMode &= ~(int)$mode;
    }

    $this->addPanel('JInfo');
    $this->addPanel('JProfile');
    $this->addPanel('JUser');
    $this->addPanel('JLanguage');
    $this->addPanel('JLog');
    $this->addPanel('JSession');
    $this->addPanel('JMail');
    $this->addPanel('JScripts');
    $this->addPanel('JStyleSheets');
    $this->addPanel('JDatabase');

    if (
         $this->panelEnabled('Server')
      || $this->panelEnabled('Request')
      || $this->panelEnabled('Get')
      || $this->panelEnabled('Post')
      || $this->panelEnabled('Cookie')
      || $this->panelEnabled('Session')
    ) {
      $this->addPanel('PHP');
    }
    $this->addPanel('Server');
    $this->addPanel('Request');
    $this->addPanel('Get');
    $this->addPanel('Post');
    $this->addPanel('Cookie');
    $this->addPanel('Session');
  }

  public function onAfterRespond()
  {
    if (!$this->enabled)
      return;

    foreach ($this->panels as $panel)
      $panel->collectData();

    Debugger::getBar()->render();
    Debugger::$showBar = false;
  }

  public function onError($error, $app)
  {
    if ($this->enabled)
      throw $error;
  }
}
