<?php
/**
 * @package n3t oEmbed
 * @author Pavel Poles - n3t.cz
 * @copyright (C) 2020 - Pavel Poles - n3t.cz
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Embera\Embera;

class plgContentN3tOEmbed extends CMSPlugin
{

  protected $autoloadLanguage = true;

  protected function renderEmbed($article, $url)
  {
    $url = strip_tags($url);

    $params = [];
    if ($this->params->get('fb_app_id') && $this->params->get('fb_app_secret'))
      $params['access_token'] = $this->params->get('fb_app_id') . '|' . $this->params->get('fb_app_secret');

    jimport('Embera.Embera');
    $embera = new Embera($params);

    $posts = $embera->getUrlData($url);

    ob_start();

    if ($posts) {
      $post = array_shift($posts);
      include PluginHelper::getLayoutPath($this->_type, $this->_name, 'post');
    } else
      include PluginHelper::getLayoutPath($this->_type, $this->_name, 'error');

    return ob_get_clean();
  }

  public function onContentPrepare($context, &$article, $params, $page = 0)
  {
    if (stripos($article->text, '{oembed') === false)
      return;

    preg_match_all('~{oembed\s(.*?)}~i', $article->text, $matches, PREG_SET_ORDER);

    if ($matches) {
      foreach ($matches as $match) {
        $output = $this->renderEmbed($article, $match[1]);
        $article->text = str_replace($match[0], $output, $article->text);
      }
    }
  }

}
