<?php
/**
 * @package     PhocaCart
 * @subpackage  PhocaCart Console Plugin
 *
 * @copyright   (C) 2022 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Plugin\Console\PhocaCart\Command;

defined('_JEXEC') or die;

use Joomla\Console\Command\AbstractCommand;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Database\DatabaseInterface;
use Joomla\Plugin\Console\PhocaCart\Console\PhocaCartStyle;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

abstract class BaseCommand extends AbstractCommand
{
	use DatabaseAwareTrait;

	/**
	 * Description for command
	 * @var string
	 * @since 4.0.0
	 */
	protected $description = '';

	/**
	 * Help for command. If empty description will be used
	 * @var string
	 * @since 4.0.0
	 */
	protected $help = null;

	/**
	 * Title disaplyed on beginning of command
	 * @var string
	 * @since 4.0.0
	 */
	protected $title = '';

	/**
	 * SymfonyStyle Object
	 * @var PhocaCartStyle
	 * @since 4.0.0
	 */
	protected $ioStyle;

	/**
	 * Return code if operation  successful
	 * @since 4.0.0
	 */
	public const RETURN_CODE_SUCCESSFUL = 0;

	/**
	 * Return code if operation failed
	 * @since 4.0.0
	 */
	public const RETURN_CODE_FAILED = 1;

	/**
	 * Return code if operation was partially successful
	 * @since 4.0.0
	 */
	public const RETURN_CODE_PARTIALLY_SUCCESSFUL = 2;

	/**
	 * Command constructor.
	 *
	 * @param   DatabaseInterface  $db  The database
	 *
	 * @since   4.2.0
	 */
	public function __construct(DatabaseInterface $db)
	{
		parent::__construct();

		$this->setDatabase($db);
	}

	/**
	 * Initialise the command.
	 *
	 * @return  void
	 *
	 * @since   4.0.0
	 */
	protected function configure(): void
	{
		$this->setDescription($this->description);
		$this->setHelp($this->help ?: $this->description);
	}

	/**
	 * Configures the IO
	 *
	 * @param   InputInterface   $input   Console Input
	 * @param   OutputInterface  $output  Console Output
	 *
	 * @return void
	 *
	 * @since 4.0.0
	 *
	 */
	protected function configureIO(InputInterface $input, OutputInterface $output)
	{
		$this->ioStyle = new PhocaCartStyle($input, $output);
		if ($this->title)
			$this->ioStyle->title('PhocaCart - ' . $this->title);
	}

	/**
	 * Loads the PhocaCart component
	 *
	 * @since 4.0.0
	 */
	protected function loadComponent(): void
	{
		\JLoader::registerPrefix('Phocacart', JPATH_ADMINISTRATOR . '/components/com_phocacart/libraries/phocacart');
		require JPATH_ADMINISTRATOR . '/components/com_phocacart/libraries/autoloadPhoca.php';
	}
}