<?php
/**
 * @package     PhocaCart
 * @subpackage  PhocaCart Console Plugin
 *
 * @copyright   (C) 2022 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Plugin\Console\PhocaCart\Command\Categories;

defined('_JEXEC') or die;

use Joomla\Plugin\Console\PhocaCart\Command\RecreateThumbnailsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class RecreateThumbnails extends RecreateThumbnailsCommand
{
	/**
	 * @inheritdoc
	 * @since 4.0.0
	 */
	protected static $defaultName = 'phocacart:categories:recreatethumbnails';

	/**
	 * @inheritdoc
	 * @since 4.0.0
	 */
	protected $description = 'Recreate categories thumbnails';

	/**
	 * @inheritdoc
	 * @since 4.0.0
	 */
	protected $title = 'Categories - Recreate thumbnails';

	/**
	 * Internal function to execute the command.
	 *
	 * @param   InputInterface   $input   The input to inject into the command.
	 * @param   OutputInterface  $output  The output to inject into the command.
	 *
	 * @return  integer  The command exit code
	 *
	 * @since   2.0.0
	 */
	protected function doExecute(InputInterface $input, OutputInterface $output): int
	{
		$this->loadComponent();
		$this->configureIO($input, $output);
		$db = $this->getDatabase();
		$warnings = [];
		$successCount = 0;
		$itemsCount = 0;

		$query = $db->getQuery(true)
			->select($db->quoteName('id'))
			->select($db->quoteName('image'))
			->from($db->quoteName('#__phocacart_categories'))
			->where($db->quoteName('image') . ' <> ' . $db->quote(''));

		$db->setQuery($query);
		$items = $db->loadObjectList();
		$itemsCount += count($items);
		if ($items) {
			$this->recreateThumbnails($items, 'categoryimage', $warnings, $successCount);
		}

		if ($itemsCount == 0) {
			$this->ioStyle->info('Nothing to update');
			return self::RETURN_CODE_SUCCESSFUL;
		}

		if ($warnings) {
			$this->ioStyle->warning('Following errors occured');
			$this->ioStyle->listing($warnings);
		}

		if ($successCount) {
			$this->ioStyle->success($successCount . ' thumbnails recreated successfully');

			if ($warnings)
				return self::RETURN_CODE_PARTIALLY_SUCCESSFUL;
			else
				return self::RETURN_CODE_SUCCESSFUL;
		}

		return self::RETURN_CODE_FAILED;
	}
}