<?php
/**
 * @package     PhocaCart
 * @subpackage  PhocaCart Console Plugin
 *
 * @copyright   (C) 2022 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Plugin\Console\PhocaCart\Command\Parameters;

defined('_JEXEC') or die;

use Joomla\Plugin\Console\PhocaCart\Command\ProductsCountCommand;

class ProductsCount extends ProductsCountCommand
{
	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected static $defaultName = 'phocacart:parameters:productscount';

	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected $description = 'Recalculates products count for parameters';

	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected $title = 'Parameters - Recalculate products count';

	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected $type = 'parameter';

	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected function loadItems(): array
	{
		$db = $this->getDatabase();

		$query = $db->getQuery(true)
			->select($db->quoteName('id'))
			->select($db->quoteName('title'))
			->from($db->quoteName('#__phocacart_parameter_values'));
		$db->setQuery($query);
		return $db->loadObjectList();
	}
}
