<?php
/**
 * @package     PhocaCart
 * @subpackage  PhocaCart Console Plugin
 *
 * @copyright   (C) 2022 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Plugin\Console\PhocaCart\Command;

defined('_JEXEC') or die;

abstract class RecreateThumbnailsCommand extends BaseCommand
{
	/**
	 * Internal function to recreate thumbnails
	 *
	 * @param   array  $items  array of products.
	 *
	 * @since   4.0.0
	 */
	protected function recreateThumbnails(array $items, string $type, array &$warnings = [], int &$successCount = 0): void
	{
		$this->ioStyle->progressStart(count($items));
		foreach ($items as $item) {
			$this->ioStyle->debugLn($item->image);
			if (\PhocacartFile::existsFileOriginal($item->image, $type)) {
				if (!\PhocacartFileThumbnail::deleteFileThumbnail($item->image, 1, 1, 1, $type)) {
					$warnings[] = 'couldn\'t delete thumbanil file ' . $item->image;
					continue;
				}

				if (!\PhocacartFileThumbnail::getOrCreateThumbnail($item->image, 0, 1, 1, 1, 0, $type)) {
					$warnings[] = 'couldn\'t create thumbanil for ' . $item->image;
					continue;
				}

				$successCount++;
			}

			$this->ioStyle->progressAdvance();
		}
		$this->ioStyle->progressFinish();
	}
}