<?php
/**
 * @package     PhocaCart
 * @subpackage  PhocaCart Console Plugin
 *
 * @copyright   (C) 2022 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Plugin\Console\PhocaCart\Command\Tags;

defined('_JEXEC') or die;

use Joomla\Plugin\Console\PhocaCart\Command\ProductsCountCommand;

class ProductsCount extends ProductsCountCommand
{
	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected static $defaultName = 'phocacart:tags:productscount';

	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected $description = 'Recalculates products count for tags';

	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected $title = 'Tags - Recalculate products count';

	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected $type = 'tag';

	/**
	 * @inheritdoc
	 * @since   4.0.0
	 */
	protected function loadItems(): array
	{
		$db = $this->getDatabase();

		$query = $db->getQuery(true)
			->select($db->quoteName('id'))
			->select($db->quoteName('title'))
			->from($db->quoteName('#__phocacart_tags'))
			->where($db->quoteName('type') . ' = 0');
		$db->setQuery($query);
		return $db->loadObjectList();
	}
}
