<?php
/**
 * @package     PhocaCart
 * @subpackage  PhocaCart Console Plugin
 *
 * @copyright   (C) 2022 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Plugin\Console\PhocaCart\Console;

defined('_JEXEC') or die;

use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class PhocaCartStyle extends SymfonyStyle
{
	public function __construct(InputInterface $input, OutputInterface $output)
	{
		parent::__construct($input, $output);
	}

	/**
	 * {@inheritdoc}
	 */
	public function comment($message)
	{
		$this->block($message, 'COMMENT', 'fg=white', ' ', true);
	}

	/**
	 * Writes white line to output, if verbosity is set to verbose
	 *
	 * @param   string  $message
	 *
	 * @since 4.0.0
	 */
	public function commentLn(string $message): void
	{
		$this->writeln(' <fg=white>' . $message . '</>', self::VERBOSITY_VERBOSE);
	}

	/**
	 * Writes gray line to output, if verbosity is set to very verbose
	 *
	 * @param   string  $message
	 *
	 * @since 4.0.0
	 */
	public function detailLn(string $message): void
	{
		$this->writeln(' <fg=gray>' . $message . '</>', self::VERBOSITY_VERY_VERBOSE);
	}

	/**
	 * Writes gray line to output, if verbosity is set to debug
	 *
	 * @param   string  $message
	 *
	 * @since 4.0.0
	 */
	public function debugLn(string $message): void
	{
		$this->writeln(' <fg=gray>' . $message . '</>', self::VERBOSITY_DEBUG);
	}

}