<?php
/**
 * @package     PhocaCart
 * @subpackage  PhocaCart Console Plugin
 *
 * @copyright   (C) 2022 - Pavel Poles - n3t.cz
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

namespace Joomla\Plugin\Console\PhocaCart\Extension;

defined('_JEXEC') or die;

use Joomla\Application\ApplicationEvents;
use Joomla\Application\Event\ApplicationEvent;
use Joomla\CMS\Application\ConsoleApplication;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Database\DatabaseInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\SubscriberInterface;
use Joomla\Plugin\Console\PhocaCart\Command;

class PhocaCart extends CMSPlugin implements SubscriberInterface
{
	use DatabaseAwareTrait;

	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  4.0.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * Database interface
	 *
	 * @var    DatabaseInterface
	 * @since  4.0.0
	 */
	protected $db = null;

	public function __construct(DispatcherInterface &$subject, array $config, DatabaseInterface $db)
	{
		parent::__construct($subject, $config);
		$this->setDatabase($db);
	}

	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 *
	 * @since   4.0.0
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			ApplicationEvents::BEFORE_EXECUTE => 'registerCLICommands',
		];
	}

	/**
	 * Registers command classes to the CLI application.
	 *
	 * @param   ApplicationEvent  $event  The before_execute application event being handled
	 *
	 * @since 4.0.0
	 */
	public function registerCLICommands(ApplicationEvent $event)
	{
		/** @var ConsoleApplication $app */
		$app = $event->getApplication();

		$app->addCommand(new Command\Products\RecreateThumbnails($this->getDatabase()));

		$app->addCommand(new Command\Categories\RecreateThumbnails($this->getDatabase()));
		$app->addCommand(new Command\Categories\ProductsCount($this->getDatabase()));

		$app->addCommand(new Command\Manufacturers\ProductsCount($this->getDatabase()));

		$app->addCommand(new Command\Labels\ProductsCount($this->getDatabase()));

		$app->addCommand(new Command\Tags\ProductsCount($this->getDatabase()));

		$app->addCommand(new Command\Parameters\ProductsCount($this->getDatabase()));
	}
}