<?php
/**
 * @package n3tLangFilter
 * @author Pavel Poles - n3t.cz
 * @copyright (C) 2010 - 2013 - Pavel Poles - n3t.cz
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );
jimport('joomla.language.helper');

class PlgContentN3tLangFilter extends JPlugin {

	public function onContentPrepare($context, &$article, &$params, $page = 0)
	{		
		if ( JString::strpos( $article->text, '{lang' ) === false ) {
			return true;
		}
		$lang = JFactory::getLanguage();
    $lang_codes 	= JLanguageHelper::getLanguages('lang_code');
    if (isset($lang_codes[$lang->getTag()])) {
      $current_lang = $lang_codes[$lang->getTag()];
		  $regex = "#{lang ".$current_lang->sef."}(.*?){\/lang}#is";
		  $article->text = preg_replace($regex,'$1', $article->text);      
		  $regex = "#{lang \!".$current_lang->sef."}(.*?){\/lang}#is";
		  $article->text = preg_replace($regex,'', $article->text);
    }
      
		$regex = "#{lang \![^}]+}(.*?){\/lang}#is";
		$article->text = preg_replace($regex,'$1', $article->text);
		$regex = "#{lang [^}]+}.*?{\/lang}#is";
		$article->text = preg_replace($regex,'', $article->text);

  	return true;
	}
	
}