<?php
/**
 * @package    Install from Bongovo! plugin
 *
 * @author     Pavel Poles - n3t.cz
 * @copyright  © 2022 Pavel Poles - n3t.cz. All rights reserved.
 * @license    GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @link       https://n3t.bitbucket.io
**/

defined('_JEXEC') or die;

use Joomla\CMS\Version;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\HTML\HTMLHelper;

if (Version::MAJOR_VERSION >= 4) {
	Factory::getApplication()->getDocument()->getWebAssetManager()
		->registerAndUseScript('plg_installer_bongovo', 'plg_installer_bongovo/bongovo.min.js', ['version' => 'auto', 'relative' => true], ['defer' => true]);
} else {
	$doc = Factory::getDocument();
  HTMLHelper::script('plg_installer_bongovo/bongovo.min.js', ['version' => 'auto', 'relative' => true], ['defer' => true]);
}

/** @var PlgInstallerBongovo $this */
?>
<legend><?php echo Text::_('PLG_INSTALLER_BONGOVO_TEXT'); ?></legend>

<div id="bongovo-message-container"></div>

<div class="card well">
  <div class="card-body">
    <input type="search" id="bongovo-search" placeholder="<?php echo Text::_('PLG_INSTALLER_BONGOVO_SEARCH'); ?>" class="form-control input-block-level" />
  </div>
</div>

<table class="table itemList" id="bongovo-table">
  <caption class="visually-hidden hidden">
	  <?php echo Text::_('PLG_INSTALLER_BONGOVO_TEXT'); ?>
  </caption>

<?php
$translations = $this->loadTranslationsToInstall();
if ($translations) {
	$title = Text::_('PLG_INSTALLER_BONGOVO_HEADING_TO_INSTALL');
	include PluginHelper::getLayoutPath('installer', 'bongovo', 'table');
}

$translations = $this->loadTranslationsInstalled();
if ($translations) {
  $title = Text::_('PLG_INSTALLER_BONGOVO_HEADING_INSTALLED');
	include PluginHelper::getLayoutPath('installer', 'bongovo', 'table');
}

$translations = $this->loadTranslationsOther();
if ($translations) {
	$title = Text::_('PLG_INSTALLER_BONGOVO_HEADING_OTHER');
	include PluginHelper::getLayoutPath('installer', 'bongovo', 'table');
}
?>
  <tbody class="search-no-results hidden">
    <tr class="table-danger error">
      <td colspan="5">
        <?php echo Text::_('PLG_INSTALLER_BONGOVO_SEARCH_NO_RESULTS'); ?>
      </td>
    </tr>
  </tbody>
</table>
