<?php
/**
 * @package    Install from Bongovo! plugin
 *
 * @author     Pavel Poles - n3t.cz
 * @copyright  © 2022 Pavel Poles - n3t.cz. All rights reserved.
 * @license    GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @link       https://n3t.bitbucket.io
**/

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Version;

if (Version::MAJOR_VERSION < 4) {
  HTMLHelper::_('bootstrap.tooltip');
}

Text::script('PLG_INSTALLER_BONGOVO_ERROR_SERVER_REQUEST');

/** @var PlgInstallerBongovo $this */
/** @var array $translations */
/** @var string $title */

?>
  <tbody>
  <tr>
    <th scope="rowgroup" colspan="5"><h3><?php echo $title;?></h3></th>
  </tr>
  <tr>
    <th scope="col">
		  <?php echo Text::_('PLG_INSTALLER_BONGOVO_TH_NAME'); ?>
    </th>
    <th scope="col" class="w-10 text-center d-none d-md-table-cell">
		  <?php echo Text::_('PLG_INSTALLER_BONGOVO_TH_LANGUAGE'); ?>
    </th>
    <th scope="col" class="w-10 text-center d-none d-md-table-cell">
		  <?php echo Text::_('PLG_INSTALLER_BONGOVO_TH_EXTENSION'); ?>
    </th>
    <th scope="col" class="w-10 text-center d-none d-md-table-cell">
		  <?php echo Text::_('PLG_INSTALLER_BONGOVO_TH_VERSION'); ?>
    </th>
    <th scope="col" class="w-5">&nbsp;</th>
  </tr>

<?php
foreach ($translations as $index => $translation) {
  $btnClass = 'primary';
	$btnText = 'PLG_INSTALLER_BONGOVO_BTN_INSTALL';
  if ($translation->installedversion) {
	  $btnClass = $translation->needupdate ? 'warning' : 'success';
	  $btnText  = $translation->needupdate ? 'PLG_INSTALLER_BONGOVO_BTN_UPDATE' : 'PLG_INSTALLER_BONGOVO_BTN_REINSTALL';
  }
?>
  <tr class="row1" data-bongovo-search="<?php echo strtolower($translation->name); ?>">
    <td class="text-left">
      <div class="break-word">
        <?php echo $translation->name; ?>
        <?php if ($translation->infourl) { ?>
          <a href="<?php echo $translation->infourl; ?>" target="_blank" class="btn btn-info btn-sm btn-mini"><span class="icon-info"></span></a>
        <?php } ?>
      </div>
      <div class="small break-word"><?php echo $translation->description; ?></div>
    </td>
    <td class="text-center center d-none d-md-table-cell">
	    <?php if ($translation->language) { ?>
	      <?php if (Version::MAJOR_VERSION >= 4) { ?>
	        <?php if ($translation->languageinstalled) { ?>
            <span class="badge badge-success bg-success" aria-describedby="bongovo-lang-<?php echo $index; ?>"><?php echo $translation->language; ?></span>
            <div role="tooltip" id="bongovo-lang-<?php echo $index; ?>">
					    <?php echo Text::_('PLG_INSTALLER_BONGOVO_LANGUAGE_INSTALLED'); ?>
            </div>
          <?php } else { ?>
            <span class="badge bg-secondary" aria-describedby="bongovo-lang-<?php echo $index; ?>"><?php echo $translation->language; ?></span>
            <div role="tooltip" id="bongovo-lang-<?php echo $index; ?>">
					    <?php echo Text::_('PLG_INSTALLER_BONGOVO_LANGUAGE_NOT_INSTALLED'); ?>
            </div>
	        <?php } ?>
	      <?php } else { ?>
			    <?php if ($translation->languageinstalled) { ?>
            <span class="badge badge-success hasTooltip" title="<?php echo Text::_('PLG_INSTALLER_BONGOVO_LANGUAGE_INSTALLED'); ?>"><?php echo $translation->language; ?></span>
			    <?php } else { ?>
            <span class="badge hasTooltip" title="<?php echo Text::_('PLG_INSTALLER_BONGOVO_LANGUAGE_NOT_INSTALLED'); ?>"><?php echo $translation->language; ?></span>
			    <?php } ?>
		    <?php } ?>
	    <?php } ?>
    </td>
    <td class="text-center center d-none d-md-table-cell">
	    <?php if($translation->extensionversion) { ?>
        <span class="badge bg-secondary">
		    <?php echo $translation->extensionversion; ?>
        </span>
	    <?php } ?>
    </td>
    <td class="text-center center d-none d-md-table-cell">
      <?php if (Version::MAJOR_VERSION >= 4 && $translation->needupdate) { ?>
        <span class="badge bg-warning text-dark" aria-describedby="bongovo-update-<?php echo $index; ?>"><?php echo $translation->installedversion; ?></span>
        <div role="tooltip" id="bongovo-update-<?php echo $index; ?>">
	        <?php echo Text::sprintf('PLG_INSTALLER_BONGOVO_UPDATE_AVAILABLE', $translation->version); ?>
        </div>
	    <?php } elseif (Version::MAJOR_VERSION < 4 && $translation->needupdate) { ?>
        <span class="badge badge-warning hasTooltip" title="<?php echo Text::sprintf('PLG_INSTALLER_BONGOVO_UPDATE_AVAILABLE', $translation->version); ?>"><?php echo $translation->installedversion; ?></span>
      <?php } elseif ($translation->version) { ?>
      <span class="badge badge-success bg-success"><?php echo $translation->version; ?></span>
      <?php } ?>
    </td>
    <td class="text-center center">
		  <?php if ($translation->detailsurl) { ?>
	      <?php if (Version::MAJOR_VERSION >= 4 && $translation->extensionversionwarning) { ?>
          <a href="#" class="btn btn-<?php echo $btnClass ?> btn-sm text-nowrap" onclick="bongovoInstall('<?php echo $translation->detailsurl; ?>'); return false;" aria-describedby="bongovo-warning-<?php echo $index; ?>">
            <span class="icon-warning" aria-hidden="true" tabindex="0"></span>&nbsp;<?php echo Text::_($btnText) ?>
          </a>
          <div role="tooltip" id="bongovo-warning-<?php echo $index; ?>">
	          <?php echo $translation->extensionversionwarning; ?>
          </div>
        <?php } elseif (Version::MAJOR_VERSION < 4 && $translation->extensionversionwarning) { ?>
          <a href="#" class="btn btn-<?php echo $btnClass ?> btn-sm text-nowrap hasTooltip" onclick="bongovoInstall('<?php echo $translation->detailsurl; ?>'); return false;" title="<?php echo $translation->extensionversionwarning; ?>" aria-label="<?php echo $translation->extensionversionwarning; ?>">
            <span class="icon-warning" aria-hidden="true" tabindex="0"></span>&nbsp;<?php echo Text::_($btnText) ?>
          </a>
			  <?php } else { ?>
          <a href="#" class="btn btn-<?php echo $btnClass ?> btn-sm text-nowrap" onclick="bongovoInstall('<?php echo $translation->detailsurl; ?>'); return false;">
					  <?php echo Text::_($btnText) ?>
          </a>
			  <?php } ?>
		  <?php } ?>
    </td>
  </tr>
<?php
}
?>
</tbody>
