<?php
/**
 * @package    Install from Bongovo! plugin
 *
 * @author     Pavel Poles - n3t.cz
 * @copyright  © 2022 - 2026 Pavel Poles - n3t.cz. All rights reserved.
 * @license    GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @link       https://n3t.bitbucket.io
**/

defined('_JEXEC') or die;

use Joomla\CMS\Version;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\HTML\HTMLHelper;

if (Version::MAJOR_VERSION >= 4) {
	Factory::getApplication()->getDocument()->getWebAssetManager()
		->registerAndUseScript('plg_installer_bongovo', 'plg_installer_bongovo/bongovo.min.js', ['version' => 'auto', 'relative' => true], ['defer' => true]);
} else {
	$doc = Factory::getDocument();
  HTMLHelper::script('plg_installer_bongovo/bongovo.min.js', ['version' => 'auto', 'relative' => true], ['defer' => true]);
}

/** @var PlgInstallerBongovo $this */
?>
<legend><?php echo Text::_('PLG_INSTALLER_BONGOVO_TEXT'); ?></legend>

<div class="d-block d-md-none hidden-desktop hidden-tablet text-center">
  <p><?php echo Text::_('PLG_INSTALLER_BONGOVO_DONATE_INTRO'); ?></p>
  <p>
    <a href="https://www.paypal.com/donate/?business=3CED3E6CLHXVY&no_recurring=0&item_name=Development support&currency_code=CZK" target=" _blank" class="btn btn-warning">
		  <?php echo HTMLHelper::_('image', 'plg_installer_bongovo/PayPal.svg', '', null, true); ?>
      <strong><?php echo Text::_('PLG_INSTALLER_BONGOVO_DONATE'); ?></strong>
    </a>
  </p>
</div>

<div class="card well">
  <div class="card-body">
    <div class="row<?php echo Version::MAJOR_VERSION == 3 ? '-fluid' : '' ?>">
      <div class="col-md-5 span5 text-center">
        <input type="search" id="bongovo-search" placeholder="<?php echo Text::_('PLG_INSTALLER_BONGOVO_SEARCH'); ?>"
               class="form-control input-block-level"/>
      </div>
      <div class="col-md-4 span4 text-center d-none d-md-block hidden-phone">
			 <?php echo Text::_('PLG_INSTALLER_BONGOVO_DONATE_INTRO'); ?>
      </div>
      <div class="col-md-3 span3 text-center d-none d-md-block hidden-phone">
        <a href="https://www.paypal.com/donate/?business=3CED3E6CLHXVY&no_recurring=0&item_name=Development support&currency_code=CZK" target=" _blank" class="btn btn-warning">
				  <?php echo HTMLHelper::_('image', 'plg_installer_bongovo/PayPal.svg', '', null, true); ?>
          <strong><?php echo Text::_('PLG_INSTALLER_BONGOVO_DONATE'); ?></strong>
        </a>
      </div>
    </div>
  </div>
</div>

<div id="bongovo-message-container"></div>

<table class="table itemList" id="bongovo-table">
  <caption class="visually-hidden hidden">
	  <?php echo Text::_('PLG_INSTALLER_BONGOVO_TEXT'); ?>
  </caption>

<?php
$hasTranslations = false;
$translations = $this->loadTranslationsToInstall();
if ($translations) {
	$title = Text::_('PLG_INSTALLER_BONGOVO_HEADING_TO_INSTALL');
	include PluginHelper::getLayoutPath('installer', 'bongovo', 'table');
	$hasTranslations = true;
}

$translations = $this->loadTranslationsInstalled();
if ($translations) {
  $title = Text::_('PLG_INSTALLER_BONGOVO_HEADING_INSTALLED');
	include PluginHelper::getLayoutPath('installer', 'bongovo', 'table');
	$hasTranslations = true;
}

$translations = $this->loadTranslationsOther();
if ($translations) {
	$title = Text::_('PLG_INSTALLER_BONGOVO_HEADING_OTHER');
	include PluginHelper::getLayoutPath('installer', 'bongovo', 'table');
	$hasTranslations = true;
}

?>
  <tbody class="<?php echo $hasTranslations ? 'search-no-results hidden' : 'no-results'; ?>">
    <tr class="table-danger error">
      <td colspan="5">
        <?php echo Text::_('PLG_INSTALLER_BONGOVO_SEARCH_NO_RESULTS'); ?>
      </td>
    </tr>
  </tbody>
</table>
