<?php
/**
 * @package n3tCopylink
 * @author Pavel Poles - n3t.cz
 * @copyright (C) 2010 - 2012 - Pavel Poles - n3t.cz
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );
jimport('joomla.language.helper');

class plgSystemN3tCopylink extends JPlugin {

	function plgSystemN3tCopylink(& $subject, $config)
	{
		parent::__construct($subject, $config);
	}

	public function onAfterDispatch()
	{		
    $app = JFactory::getApplication();
    if ($app->isSite()) {
      $doc =& JFactory::getDocument();
      JHtml::script('plg_n3tcopylink/copylink.js',false,true);

      $this->loadLanguage('', JPATH_ADMINISTRATOR);

      $suffix = $this->params->def('suffix', JText::_('PLG_SYSTEM_N3TCOPYLINK_DEFAULT_SUFFIX'));
      $suffix = str_replace(array("\n","\r","'"),array("","","\'"),$suffix);
      $suffix = preg_replace('/{url}/i',"'+location.href+'",$suffix);
      $min_selection = (int)$this->params->def('min_selection', 20);

      $doc->addScriptDeclaration("
        CopyLink.addEvent(window, 'load', function () {
        	new CopyLink({
        		container : document.body,
        		handler : function () {
        			return '".$suffix."';
        		},
            minimalSelection: ".$min_selection."
        	});
        });
      ");
    }
	}
}
